//units are in meters

//get some colors
#include "colors.inc"

// place all settings of globally influenced features here
global_settings {
	ambient_light Yellow
}

//one light source
light_source {
	<20, 35, -2>
	color White
}

//camera is on the surface
camera {
	location  <-2, 0, 0>
	look_at   <-5, -3, 2>
}

//the center of the universe
sphere {
	<0, 0, 0>
	2
	pigment {
		bozo
		color_map {
			[0.00 White]
			[0.45 SkyBlue]
			[0.55 SkyBlue]
			[0.70 White]
			[1.00 White]
		}
		warp {
			turbulence .5
		}
	}
}

//ring around the sphere
difference {
	cylinder {
		<0, -.01, 0>, <0, .01, 0>, 1
	
	}

	cylinder {
		<0, -.02, 0>, <0, .02, 0>, .8
	}
	
	pigment {
		cylindrical
		frequency 8
		color_map {
			[0.00 Magenta filter .5]
			[0.30 Yellow filter .5]
			[0.45 Green filter .5]
			[0.60 Cyan filter .5]
			[1.00 Magenta filter .5]
		}
	}

	scale <3.2, 1, 3.2>
	
	rotate <0, 0, 30>
}

//the moon
sphere {
	<6, 0, 0>
	.4
	pigment {
		color Grey
	}
	normal {
		bumps 1.5
		scale .1
	}
	rotate <0, 200, 27>
}


sky_sphere {
	pigment {
		bozo
		color_map {
			[0.00 White*3]
			[0.20 Black]
			[1.00 Black]
		}
		scale .006
	}
}
